#include <GL/glut.h>
//
// listak a gombhoz s kockahoz
//
GLuint sphereList, cubeList;
//
// forgatasi szogek
//
float fRotx=30,fRoty=30;
//
// init fuggveny: a listak elkeszitese
//
void init(void)
	{
   GLfloat mat_specular[] = { 1.0, 1.0, 1.0, 0.15 };
   GLfloat mat_shininess[] = { 100.0 };					// intenziv visszaverd tartomany
   GLfloat position[] = { 0.5, 0.5, 1.0, 0.0 };

   glMaterialfv(GL_FRONT, GL_SPECULAR, mat_specular);
   glMaterialfv(GL_FRONT, GL_SHININESS, mat_shininess);
   glLightfv(GL_LIGHT0, GL_POSITION, position);

   glEnable(GL_LIGHTING);
   glEnable(GL_LIGHT0);
   glEnable(GL_DEPTH_TEST);									// z-buffering van
	//
	// a gomb
	//
   sphereList = glGenLists(1);
   glNewList(sphereList, GL_COMPILE);
      glutSolidSphere (0.6, 16, 16);						// meretek kiserletezs alapjan
   glEndList();
	//
	// kocka
	//
   cubeList = glGenLists(1);
   glNewList(cubeList, GL_COMPILE);
      glutSolidCube (1.6);										// meret kiserletezs alapjan
   glEndList();
	}

void display(void)
	{
   GLfloat mat_solid[] = { 0.75, 0.75, 0.0, 1.0 };
   GLfloat mat_zero[] = { 0.0, 0.0, 0.0, 1.0 };
   GLfloat mat_transparent[] = { 0.0, 0.8, 0.8, 0.5};
   GLfloat mat_emission[] = { 0.0, 0.3, 0.3, 0.6 };

   glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

   glPushMatrix ();
      glMaterialfv(GL_FRONT, GL_EMISSION, mat_zero);
      glMaterialfv(GL_FRONT, GL_DIFFUSE, mat_solid);
      glCallList (sphereList);
   glPopMatrix ();

   glPushMatrix ();
      glRotatef (fRotx, 1.0, 1.0, 0.0);
      glRotatef (fRoty, 0.0, 1.0, 0.0);
      glMaterialfv(GL_FRONT, GL_EMISSION, mat_emission);
      glMaterialfv(GL_FRONT, GL_DIFFUSE, mat_transparent);
      
		glEnable (GL_BLEND);
      
		glDepthMask (GL_FALSE);
      
		glBlendFunc (GL_SRC_ALPHA, GL_ONE);
      
		glCallList (cubeList);
      
		glDepthMask (GL_TRUE);
      glDisable (GL_BLEND);
   glPopMatrix ();
	glFlush();
   glutSwapBuffers();
	}

void reshape(int w, int h)
	{
   glViewport(0, 0, (GLint) w, (GLint) h);
   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();
   if (w <= h)
		{
      glOrtho (-1.5, 1.5, -1.5*(GLfloat)h/(GLfloat)w,
               1.5*(GLfloat)h/(GLfloat)w, -10.0, 10.0);
		}
   else
		{
      glOrtho (-1.5*(GLfloat)w/(GLfloat)h,
               1.5*(GLfloat)w/(GLfloat)h, -1.5, 1.5, -10.0, 10.0);
		}
   glMatrixMode(GL_MODELVIEW);
   glLoadIdentity();
	}

void keyboard(unsigned char key, int x, int y)
	{
   switch (key) 
		{
      case 'a':
			fRotx+=5;
			fRoty+=5;
         glutPostRedisplay();
         break;
      case 'r':
         glutPostRedisplay();
         break;
		}
	}

main(int argc, char** argv)
	{
   glutInit(&argc, argv);
   glutInitDisplayMode (GLUT_DOUBLE | GLUT_RGB | GLUT_DEPTH);
   glutInitWindowSize(500, 500);
   glutCreateWindow(argv[0]);
   init();
   glutReshapeFunc(reshape);
   glutKeyboardFunc(keyboard);
   glutDisplayFunc(display);
   glutMainLoop();
	return(0);
	}
